;----------------------------------------------------------------------------
;     MODULE NAME:   ICE.MM
;
;         $Author:   USER "Dennis"  $
;       $Revision:   1.4  $
;           $Date:   11 Nov 2004 18:09:42  $
;        $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/ICE.mm.pvcs  $
;
;     DESCRIPTION:   Simple demonstration validation
;
;                    Each ICE block creates its own VBS custom Action.
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;--- Some definitions (we will add to the SDK supplied "logo.cub) ---------
;----------------------------------------------------------------------------
#define  TEMPLATE     C:\Program Files\MsiVal2\logo.cub
#define  DESCRIPTION  Validations Plus Custom (by Dennis Bareis)


;----------------------------------------------------------------------------
;--- Make sure that the TEMPLATE exists -------------------------------------
;----------------------------------------------------------------------------
#if FileQueryExists("<$TEMPLATE>") = ''
    #error ^The CUB file "<$TEMPLATE>" doesn't exist!{NL}Have you installed MSIVAL2?^
#endif


;----------------------------------------------------------------------------
;--- Include ICE support ----------------------------------------------------
;----------------------------------------------------------------------------
#include "ICE.MMH"


;----------------------------------------------------------------------------
;--- START ------------------------------------------------------------------
;----------------------------------------------------------------------------
<$Msi "<$DESCRIPTION>.CUB" template="<$Template>">


;----------------------------------------------------------------------------
;--- Update some summary Information ----------------------------------------
;----------------------------------------------------------------------------
<$Summary "Author"       Value="Dennis Bareis">
<$Summary "Comments"     Value="<$DESCRIPTION>.">


;----------------------------------------------------------------------------
;--- Make sure there is "room" at the start for all our validations ---------
;----------------------------------------------------------------------------
#define MAX_ICES_TO_ADD         100     ;;The max we will create! Doesn't really matter if we have more (but I want all mine before any other)
#define MAX_VALID_SEQ_NUMBER    32766   ;;This last sequence number (32767) is reserved (by me)
say ""
say "MAKING ROOM FOR MY ACTIONS AT THE START"
say "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
<$Table "_ICESequence">
dim OldSeqNumber, NewSeqNumber, ValidationsName
<$Row @Where="" @OK='>0' @Code="Y" *Sequence="NewSeqNumber">
    ;--- Get current sequence number and bump it up -------------------------
    ValidationsName = <$COLSTR._ICESequence.Action>
    OldSeqNumber    = <$COLINT._ICESequence.Sequence>
    NewSeqNumber    = OldSeqNumber + <$MAX_ICES_TO_ADD>

    ;--- If the number is too high then we'll leave it where it is ----------
    say "MOVING: """ & ValidationsName & """ (from " & OldSeqNumber & " to " & NewSeqNumber & ")."
    if  NewSeqNumber < 0 or NewSeqNumber > <$MAX_VALID_SEQ_NUMBER> then
        ;--- Restore value --------------------------------------------------
        NewSeqNumber = OldSeqNumber

        ;--- Tell someone! --------------------------------------------------
        say "        Could not move (max sequence is <$MAX_VALID_SEQ_NUMBER>)"
    end if
<$/Row>
<$/Table>
say ""


;----------------------------------------------------------------------------
;--- Workaround to ICE20 bug (Move it to end, if it dies, well OK...) -------
;----------------------------------------------------------------------------
<$Table "_ICESequence">
   #(
       <$Row
             @Where="Action = 'ICE20'"
                @OK='=1'
          *Sequence="<$MAX_VALID_SEQ_NUMBER>+1"  ;;Original value = 200
       >
   #)
<$/Table>


;----------------------------------------------------------------------------
;--- First ICE (basically just VBSCRIPT) ------------------------------------
;----------------------------------------------------------------------------
<$Ice "DB1">
   ;--- Output an ERROR "DB102" (location unknown/unspecified) --------------
   IceError   "02", "Oops"

   ;--- Output another error message (ORCA will/can highlight) --------------
   IceError   "71", "Pretend Binary table Issue (no column/row info)!" & IceLocation("Binary", "", "")

   ;--- Check components ----------------------------------------------------
   LookForEmptyComponentKeyPathAndNoCreateFolderEntry()

   ;--- We now wish to define subroutines -----------------------------------
   <$IceEndMainline>                  ;;Not required if all in mainline


   '********************************************
   sub LookForEmptyComponentKeyPathAndNoCreateFolderEntry()
   '********************************************
       ;--- Make sure we have a component table! ----------------------------
       IceDebug("LookForEmptyComponentKeyPathAndNoCreateFolderEntry(START): " & Err.number & " - " & err.description)
       if  Database.TablePersistent("Component") <> 1 then
           IceDebug("There is no ""Component"" table so exiting validation!")
       else
           ;--- Loop through all "Components" -------------------------------
           dim oViewComp, oRecComp
           set oViewComp = IceViewOpen("SELECT `Component`, `Directory_`, `Attributes`, `KeyPath` FROM `Component`")
           if  oViewComp is Nothing then exit sub
           do
               ;--- Get next record, exit at end ----------------------------
               set oRecComp = IceViewFetch(oViewComp)
               if oRecComp is nothing then exit do

               ;--- Process this record -------------------------------------
               if  oRecComp.IsNull(4) then
                   ;--- Have empty keypath (get values) ---------------------
                   dim cComponent, cDirectory, cAttributes, cKeyPath
                   cComponent  = oRecComp.StringData(1)
                   cDirectory  = oRecComp.StringData(2)
                   cAttributes = oRecComp.IntegerData(3)
                   cKeyPath    = oRecComp.StringData(4)
                   IceDebug("Looking at the component """ & cComponent & """")

                   ;--- See if in the "CreateFolder" table ------------------
                   dim InTbl : InTbl = false
                   if  Database.TablePersistent("CreateFolder") <> 1 then
                       IceDebug("There is no ""CreateFolder"" table...")
                   else
                       ;--- "CreateFolder" exists so look for entry for the dir ---
                       dim oViewCF, oRecCF
                       set oViewCF = IceViewOpen("SELECT `Directory_`, `Component_` FROM `CreateFolder` WHERE `Directory_` = '" & cDirectory & "'")
                       if  oViewCF is Nothing then exit sub
                       set oRecCF  = IceViewFetch(oViewCF)
                       if  not oRecCF is nothing then
                           InTbl = true
                       end if
                       IceViewClose(oViewCF)
                   end if
                   if  not InTbl then
                       IceWarning "11", "Component """ & cComponent & """ has an empty KeyPath and the directory """ & cDirectory & """ is not in the ""CreateFolder"" table." & IceLocation("Component", "KeyPath", cComponent)
                   end if
               end if
           loop
           IceViewClose(oViewComp)
       end if

       ;--- End of function -------------------------------------------------
       IceDebug("LookForEmptyComponentKeyPathAndNoCreateFolderEntry(END): " & Err.number & " - " & err.description)
   end sub
<$/Ice>


;----------------------------------------------------------------------------
;--- END --------------------------------------------------------------------
;----------------------------------------------------------------------------
<$/Msi>

